package baseClass;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Jonhnanthan Victor
 *
 */
public class Arquivo {
	
	private FileWriter out = null;
	private FileReader arq = null;
	private BufferedReader buffer = null;
	private List<String> linhas = new ArrayList<String>();
	
	/**
	 * executa a leitura de um arquivo passado como parametro
	 * @param arquivo
	 * 		o nome do arquivo a ser lido (melhor aplicacao com seu caminho completo)
	 * @throws Exception
	 * 		lanca excessao caso o arquivo passado nao seja encontrado e caso nao consiga ler
	 */
	public void lerArquivo(String arquivo) throws Exception{
		try {
			arq = new FileReader(arquivo);
			buffer = new BufferedReader(arq);
		} catch (Exception e) {
			throw new Exception("Arquivo nao encontrado!");
		}
		
		String linha;
		try {
			while (true) {
				linha = buffer.readLine();
				if (linha != null){
					linhas.add(linha);
				} else{
					break;
				}
			}
			buffer.close();
			arq.close();
		} catch (IOException e) {
			throw new Exception("Erro ao ler o arquivo!");
		}		
	}

	
	/**
	 * Apos ler um determinado arquivo, usa-se este metodo para obter todas as linhas lidas
	 * @return
	 * 		arraylist com todas as linhas, cada linha eh um indice do array
	 */
	public List<String> getLinhasDoArquivoLido(){
		return linhas;
	}	
	
	/**
	 * Escreve num determinado arquivo o que eh pedido
	 * @param aEscrever
	 * 			string com tudo que eh necessario escrever no arquivo
	 * @param nomeArquivo
	 * 			o nome do arquivo a ser escrito (melhor aplicacao com seu caminho completo)
	 * @throws Exception
	 * 			lanca excessao aso nao consiga abrir o arquivo para escrita
	 */
	public void escreverEmArquivo(String aEscrever, String nomeArquivo) throws Exception{
		
		String fimDeLinha = System.getProperty("line.separator");
		aEscrever = fimDeLinha + aEscrever;
		
		try {
			out = new FileWriter(nomeArquivo, true);
			out.append(aEscrever);
			out.close();
		} catch (Exception e) {
			throw new Exception("Erro ao abrir o arquivo para escrita!");
		}
	}
	
	/**
	 * Testa o formato do arquivo onde contem o nome do estabelecimento, seu endereco
	 * e o tipo de prato servido.
	 * @param nomeArquivo
	 * 			nome do arquivo que contem as informacoes necessarias
	 * @return
	 * 			-1 : o arquivo esta vazio
	 * 			 0 : o arquivo nao esta no formato correto
	 * 			 1 : o arquivo esta no formato correto
	 * @throws Exception
	 * 			lanca a mesma excessao da leitura de arquivo
	 */
	public int testaPadraoArquivoDeEstabelecimentos(String nomeArquivo) throws Exception{
        lerArquivo(nomeArquivo);

		
		if (getLinhasDoArquivoLido().isEmpty()){
			return -1;
		}
		
		for (String linha : getLinhasDoArquivoLido()){
			String[] testaLinha = linha.split(";");
			if (testaLinha.length != 3){
				return 0;
			}
		}
		return 1;
	}

	/**
	 * Testa o formato do arquivo onde contem as opinioes dos usuarios
	 * O arquivo tem indicacao de data e hora, nome do user e suas opinioes
	 * @param nomeArquivo
	 * 			nome do arquivo que contem as informacoes necessarias
	 * @return
	 * 			-1 : o arquivo esta vazio
	 * 			 0 : o arquivo nao esta no formato correto
	 * 			 1 : o arquivo esta no formato correto
	 * @throws Exception
	 * 			lanca a mesma excessao da leitura de arquivo
	 */
	public int testaPadraoArquivoDeOpinioes(String nomeArquivo) throws Exception{
        lerArquivo(nomeArquivo);
		
		if (getLinhasDoArquivoLido().isEmpty()){
			return -1;
		}

		for (String linha : getLinhasDoArquivoLido()){
			String[] testaLinha = linha.split(";");
			if (testaLinha.length != 41){
				return 0;
			}
		}
		
		return 1;
	}
}